<?php
require_once("../layouts/members/head.php");
if (in_array($user_data['usertype'], ['Master Distributor', 'Distributor', 'Retailer'])) {
?>
<div class="row">
    <div class="col-md-4 mb-2">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <div class="d-flex align-items-center">
            <span class="mr-auto"><?= file_name() ?></span>
            <button class="btn btn-dark btn-sm ml-auto" onclick="history.back()">
              <i class="fas fa-arrow-left"></i> Back
            </button>
          </div>
        </div>
        <div class="p-3 text-dark">
          <?php
          $postOffice = []; // Initialize array
          $response = [];   // Initialize response array

          if (isset($_POST['submit'])) {
              $pincode = strtoupper(trim($_POST['pincode']));

              if (!empty($pincode)) {
                  $amount = $user_data['pincode_verify_fee'];
                  $old_balance = $user_data['balance'];
                  $new_balance = $old_balance - $amount;

                  if ($old_balance >= $amount) {
                      $order_id = order_txn_id();
                      
                      // --- NEW API IMPLEMENTATION START ---
                      $apiKey = "APIKEYPASTEE"; // Buy APi From This Website https://apizone.co.in ( Design & Development By APIZONE )
                      $apiUrl = "https://kycapizone.in/api/v2/pincode/pincode_verification.php?api_key=" . $apiKey . "&pincode=" . $pincode;

                      $curl = curl_init();
                      curl_setopt_array($curl, array(
                         CURLOPT_URL => $apiUrl,
                         CURLOPT_RETURNTRANSFER => true,
                         CURLOPT_ENCODING => '',
                         CURLOPT_MAXREDIRS => 10,
                         CURLOPT_TIMEOUT => 30,
                         CURLOPT_FOLLOWLOCATION => true,
                         CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
                         CURLOPT_CUSTOMREQUEST => 'GET',
                         CURLOPT_SSL_VERIFYPEER => false,
                      ));

                      $responseApi = curl_exec($curl);
                      curl_close($curl);
                      
                      $json_data = json_decode($responseApi, true) ?? [];

                      // Check if API success
                      if (isset($json_data['status']) && $json_data['status'] == '100') {
                          
                          $response['status'] = '100';
                          $response['message'] = $json_data['result']['message'] ?? 'Data Found';
                          
                          // Extract Post Office Data
                          $postOffice = $json_data['result']['post_offices'] ?? [];
                          
                          // Get state from first result for report/sms (fallback to NA)
                          $stateName = $postOffice[0]['State'] ?? 'NA';

                          $updateSuccess = db_update("members", ["balance" => $new_balance], "user_id='{$user_data['user_id']}'");

                          if ($updateSuccess) {
                              $insData = [
                                  'site_id'       => $site_data['site_id'],
                                  'user_id'       => $user_data['user_id'],
                                  'username'      => $user_data['username'],
                                  'name'          => $user_data['name'],
                                  'operator'      => $user_data['usertype'],
                                  'parent_id'     => $user_data['parent_id'],
                                  'order_id'      => $order_id,
                                  'service'       => "PINCODEVERIFY",
                                  'type'          => "Debit",
                                  'account_number'=> $stateName,
                                  'app_type'      => "PINCODEVERIFY",
                                  'amount'        => $amount,
                                  'main_amount'   => $amount,
                                  'old_balance'   => $old_balance,
                                  'new_balance'   => $new_balance,
                                  'txn_id'        => $order_id,
                                  'ref_id'        => $stateName,
                                  'description'   => "Rs.{$amount} Has Been Debit From Wallet for Name {$stateName} PIN code ",
                                  'date_time'     => current_timestamp(),
                                  'status'        => "Success"
                              ];

                              $insertId = db_insert("reports", $insData);
                              if ($insertId) {
                                  // Prepare SMS Fields - Mapping API Keys to Display Labels
                                  $fields = [
                                      'Name' => 'Name',
                                      'BranchType' => 'Branch',
                                      'Circle' => 'Circle',
                                      'District' => 'District',
                                      'Region' => 'Region',
                                      'Block' => 'Block',
                                      'State' => 'State',
                                      'Country' => 'Country',
                                      'Pincode' => 'Pincode',
                                  ];

                                  $whamessage = "Dear {$user_data['name']},\nYour Request for PIN Code *{$pincode}* Searching has been Complete.\n\n";
                                  
                                  // Use data from the first post office found
                                  if(!empty($postOffice) && isset($postOffice[0])){
                                      foreach ($fields as $key => $label) {
                                          if (!empty($postOffice[0][$key])) {
                                              $whamessage .= "*$label*: {$postOffice[0][$key]}\n";
                                          }
                                      }
                                  }
                                  
                                  $whamessage .= "\nBest Regards,\n_*{$site_data['brand']}.*_";
                                  send_sms($user_data['mobile'], $whamessage);
                              } else {
                                  awal_alert_msg("Insert Server Error!", 'error');
                              }
                          } else {
                              awal_alert_msg("Balance debited from wallet but not updated in the database. Please contact support!", 'error');
                          }
                      } else {
                          // Handle API Failure
                          $msg = $json_data['message'] ?? 'Server Down or Pincode Not Found';
                          awal_alert_msg($msg, 'error');
                      }
                      // --- NEW API IMPLEMENTATION END ---
                  } else {
                      awal_alert_msg("Insufficient Wallet Balance!", 'error');
                  }
              } else {
                  awal_alert_msg("Please Fill All Valid Details!", 'error');
              }
          }
          ?>
          <form action="" method="POST" class="row">
            <div class="col-md-12 mb-3">
              <label>Pincode Number</label>
              <input type="text" name="pincode" placeholder="Enter Pincode Number" maxlength="6" oninput="this.value = this.value.toUpperCase().replace(/\s+/g, '');" class="form-control" required>
            </div>
            <div class="col-md-12 mb-3 d-flex justify-content-between">
              <button type="button" class="btn btn-secondary">
                <i class="fas fa-inr"></i> <?= $user_data['pincode_verify_fee']; ?>
              </button>
              <button type="submit" name="submit" class="btn btn-primary" onclick="return confirm('Are you sure?');">Submit</button>
            </div>
          </form>
        </div>
      </div>
    </div>
    <?php if (isset($response['status']) && $response['status'] == '100' && !empty($postOffice)) {  ?>
    <div class="col-md-12 mt-4">
      <div class="card text-danger">
        <div class="card-header bg-primary text-white py-2">
          <span class="mr-auto"><?php echo $response['message'] ?? 'Pincode Details'; ?></span>
        </div>
        <div class="table-responsive">
          <table class="table table-bordered table-striped">
            <thead>
              <tr style="text-align: center;">
                <th>Sr. No.</th>
                <th>Pincode</th>
                <th>Name</th>
                <th>Delivery Status</th>
                <th>Circle</th>
                <th>District</th>
                <th>Block</th>
                <th>State</th>
                <th>Country</th>
              </tr>
            </thead>
            <tbody>
              <?php 
              $srNo = 1; 
              foreach ($postOffice as $postOffices) { ?>
                <tr style="text-align: center;">
                  <td><?= $srNo++; ?></td>
                  <td><?= $postOffices['Pincode'] ?? ''; ?></td>
                  <td><?= $postOffices['Name'] ?? ''; ?></td>
                  <td>
                    <?php 
                    $deliveryStatus = $postOffices['DeliveryStatus'] ?? '';
                    if ($deliveryStatus == 'Delivery') { ?>
                      <button class="btn btn-success"><b>Delivery</b></button>
                    <?php } else { ?>
                      <button class="btn btn-danger"><b><?= $deliveryStatus; ?></b></button>
                    <?php } ?>
                  </td>
                  <td><?= $postOffices['Circle'] ?? ''; ?></td>
                  <td><?= $postOffices['District'] ?? ''; ?></td>
                  <td><?= $postOffices['Block'] ?? ''; ?></td>
                  <td><?= $postOffices['State'] ?? ''; ?></td>
                  <td><?= $postOffices['Country'] ?? ''; ?></td>
                </tr>
              <?php } ?>
            </tbody>
          </table>
        </div>
      </div>
    </div>
    <?php } ?>
</div>
<?php
} else {
    require_once("404.php");
}

require_once("../layouts/members/foot.php");
?>